# Check all system components and writes report

import asyncio
import os
import json
import datetime
import sys
import socket
import fnmatch
import configparser
import traceback
import math
import re

from fleming.common.firmware_util import EEFAnalogInput
from fleming.common.firmware_util import get_fan_control_endpoint
from fleming.common.firmware_util import get_node_endpoint
from fleming.system_test.fle_sys import *


from pylog.pylogger import PyLogger

from py_pli.pylib import VUnits
from py_pli.pylib import send_msg
from py_pli.pylib import GlobalVar

# Global Constants
# =============================================================================

PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
INSTRUMENT = socket.gethostname()

# Hardware Dicts
all_mover = {
    'fm': VUnits.instance.hal.focusMover,
    'st': VUnits.instance.hal.scan_table,
    'pd': VUnits.instance.hal.plateDoor,
    'fms': VUnits.instance.hal.filterModuleSlider,
    'das1': VUnits.instance.hal.detectorApertureSlider1,
    'das2': VUnits.instance.hal.detectorApertureSlider2,
    'els': VUnits.instance.hal.excitationLightSelector,
    'bld': VUnits.instance.hal.bottomLightDirector,
    'sd': VUnits.instance.hal.doorLatch,
}

# Low Level Functions
# System

def report_header(filename):
    today = datetime.now().strftime('%Y%m%d')
    header = f'System Check {today} on {INSTRUMENT}:\n'
    with open(filename, 'a') as report:
        report.write(header)
    return(header)

async def mover_check(mover):
    # Homing, move 2, homing, return step errors
    try:   
        c_mover = all_mover[mover]
        await c_mover.Home()
        if mover == 'st':
            await c_mover.Move(2,2)
        else:
            await c_mover.Move(2)
        step_errors = await c_mover.Home()
    except Exception as ex:
        return(f'Mover {mover} failed')
    return(f'Mover {mover}: Step Errors: {step_errors}')


# High Level Checks

async def sys_chk(system = 1, interlock = 0, optic = 0, mover = 0, temperature = 0):
    # Main Function to check system Modules
    testname = sys._getframe().f_code.co_name  # get function name from sys

    report_filename = get_reportfile(PATH, BASE_NAME, testname)
    report_header(report_filename)

    if system:
        py_version = py_ver()
        fw_version = await hw_ver()
        with open (report_filename, 'a') as report:
            report.write(f'  PyRunner Version: {py_version} \n')
            report.write(f' Firmware versions: {fw_version} \n')

    if optic:
        flashlamp_result = chk_fl()
        alpha_result = chk_al()
        trf_laser_result = chk_trf()
        ref_pd_result = chk_refpd()
        abs_pd_result = chk_abspd()
        pmt1_result = chk_pmt1()
        pmt2_result = chk_pmt2()
        with open (report_filename, 'a') as report:
            report.write(f'     Flashlamp Check:\n')
            report.write(f'   Alpha Laser Check:\n')
            report.write(f'     TRF Laser Check: \n')
            report.write(f'  Reference PD Check:\n')
            report.write(f' Absorbance PD Check:\n')
            report.write(f' PMT Channel 1 Check:\n')
            report.write(f' PMT Channel 2 Check:\n')
            
    if mover:
        pass

    if temperature:
        pass

    return



